#include "../include/typedefs.h"

// Example code from MISRA C:2012 begin
extern int16_t count;
       int16_t count = 0;       /* Compliant                         */

extern uint16_t speed = 6000u;  /* Non-compliant - no declaration
                                 * prior to this definition		*/
uint8_t pressure = 101u;        /* Non-compliant - no declaration
                                 * prior to this definition		*/

extern void func1 ( void );
extern void func2 ( int16_t x, int16_t y );
extern void func3 ( int16_t x, int16_t y );

void func1 ( void )
{
  /* Compliant */
}

void func2 ( int16_t x, int16_t y )
{
  /* Compliant                                 */
}

void func3 ( int16_t x, uint16_t y )
{
  /* Non-compliant - parameter types different */
}

void func4 ( void )
{
  /* Non-compliant - no declaration of func4 before this definition    */
}

static void func5 ( void )
{
  /* Compliant - rule does not apply to object/functions with internal 
   * linkage                                                           */
}
// Example code from MISRA C:2012 end
